<?php 
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    class Form {
        private $db;
        private $id;
        private $nome;
        private $spazioOccupato;
        private $tipoConfermaMessaggioInviato;
        private $emailNotificaAmministratore;
        private $rispondiA;
        private $oggettoNotificaAmministratore;
        private $testoMessaggioInviato;
        private $testoMessaggioErrore;
        private $paginaRingraziamento;
        private $linkPrivacy;
        private $azione;
        private $formInLinea;
        private $stile; 
        private $testo;
        private $spuntaPrivacy;
        private $stampaLinkPaginaForm;
        private $etichettaPulsante;
        private $iconaPulsante;
        private $spazioOccupatoPulsante;
        private $linkScriptEsterno;
        private $linkScriptRicerca;
        private $usaAjax;
        private $noteAggiuntive;
        private $attivaNotificaUtente;
        private $campoEmailNotificaUtente;
        private $nomeMittenteNotificaUtente;
        private $emailMittenteNotificaUtente;
        private $oggettoNotificaUtente;
        private $templateEmailNotificaUtente;
        private $mostraTitoloComponente;
        
        function __construct($db, $id, $nome="", $emailNotificaAmministratore="", $oggettoNotificaAmministratore="", $tipoConfermaMessaggioInviato="", $testoMessaggioInviato="", $testoMessaggioDiErrore="", $paginaRingraziamento=0, $linkPrivacy="", $azione="", $etichettaPulsante="", $iconaPulsante="", $spazioOccupatoPulsante="", $spazioOccuapto="", $formInLinea="", $stile="", $spuntaPrivacy="", $testo="", $stampaLinkPaginaForm="",$noteAggiuntive="",$templateEmailNotificaUtente=0) {
            $this->db   = $db;
            $this->id   = $id;
            $this->nome = $nome;
            $this->tipoConfermaMessaggioInviato = $tipoConfermaMessaggioInviato;
            $this->emailNotificaAmministratore  = $emailNotificaAmministratore;
            $this->oggettoNotificaAmministratore= $oggettoNotificaAmministratore;
            $this->testoMessaggioInviato        = $testoMessaggioInviato;
            $this->testoMessaggioErrore         = $testoMessaggioDiErrore;
            $this->paginaRingraziamento         = $paginaRingraziamento;
            $this->linkPrivacy                  = $linkPrivacy;
            $this->azione                       = $azione;
            $this->etichettaPulsante            = $etichettaPulsante;
            $this->iconaPulsante                = $iconaPulsante;
            $this->spazioOccupatoPulsante       = $spazioOccupatoPulsante;
            $this->spazioOccupato               = $spazioOccuapto;
            $this->formInLinea                  = $formInLinea;
            $this->stile                        = $stile;
            $this->spuntaPrivacy                = $spuntaPrivacy;
            $this->stampaLinkPaginaForm         = $stampaLinkPaginaForm;
            $this->testo                        = $testo;
            $this->noteAggiuntive               = $noteAggiuntive;
            $this->templateEmailNotificaUtente  = $templateEmailNotificaUtente;
        }

        function crea() {
            $query    = "INSERT INTO geec_form VALUES(NULL,'$this->nome','$this->spazioOccupato','$this->tipoConfermaMessaggioInviato','$this->emailNotificaAmministratore', '$this->rispondiA', '$this->oggettoNotificaAmministratore','$this->testoMessaggioInviato','$this->testoMessaggioErrore',$this->paginaRingraziamento,'$this->formInLinea','$this->testo','$this->stampaLinkPaginaForm','$this->spuntaPrivacy','$this->linkPrivacy','$this->azione','$this->etichettaPulsante','$this->iconaPulsante','$this->spazioOccupatoPulsante','$this->linkScriptEsterno','$this->linkScriptRicerca','$this->usaAjax','$this->noteAggiuntive',0,'$this->attivaNotificaUtente','$this->campoEmailNotificaUtente','$this->nomeMittenteNotificaUtente','$this->emailMittenteNotificaUtente','$this->oggettoNotificaUtente','$this->templateEmailNotificaUtente','$this->mostraTitoloComponente')";
            $this->id = $this->db->eseguiQueryCreazione($query);
            return $this->id;
        }
        
        function modificaInformazioniPrincipali() {
            $query    = "UPDATE geec_form SET nome='$this->nome', spazioOccupato='$this->spazioOccupato', formInLinea='$this->formInLinea', testo='$this->testo', stampaLinkPaginaForm='$this->stampaLinkPaginaForm', spuntaPrivacy='$this->spuntaPrivacy', linkPrivacy='$this->linkPrivacy', azione='$this->azione', etichettaPulsante='$this->etichettaPulsante', iconaPulsante='$this->iconaPulsante', spazioOccupatoPulsante='$this->spazioOccupatoPulsante', linkScriptEsterno='$this->linkScriptEsterno', linkScriptRicerca='$this->linkScriptRicerca', usaAjax='$this->usaAjax', noteAggiuntive='$this->noteAggiuntive', mostraTitoloComponente='$this->mostraTitoloComponente' WHERE id=$this->id";
            $this->db->eseguiQueryScrittura($query);
        }

        function modificaDatiConferme() {
            $query    = "UPDATE geec_form SET tipoConfermaMessaggioInviato='$this->tipoConfermaMessaggioInviato', testoMessaggioInviato='$this->testoMessaggioInviato', testoMessaggioErrore='$this->testoMessaggioErrore', paginaRingraziamento=$this->paginaRingraziamento WHERE id=$this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function modificaDatiNotifiche() {
            $query    = "UPDATE geec_form SET emailNotificaAmministratore='$this->emailNotificaAmministratore', rispondiA='$this->rispondiA', oggettoNotificaAmministratore='$this->oggettoNotificaAmministratore', stampaLinkPaginaForm='$this->stampaLinkPaginaForm', attivaNotificaUtente='$this->attivaNotificaUtente', campoEmailNotificaUtente='$this->campoEmailNotificaUtente', nomeMittenteNotificaUtente='$this->nomeMittenteNotificaUtente', emailMittenteNotificaUtente='$this->emailMittenteNotificaUtente', oggettoNotificaUtente='$this->oggettoNotificaUtente', templateEmailNotificaUtente='$this->templateEmailNotificaUtente'  WHERE id=$this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function elimina() {
            $this->db->eseguiQueryCancellazione("geec_form",$this->id);

            $query       = "SELECT * FROM geec_elementiForm WHERE idForm='$this->id'";
            $risElementi = $this->db->eseguiQueryLettura($query);
            while($elementoDaEliminare = $risElementi->fetch_assoc()) {
                $this->eliminaElemento($elementoDaEliminare["id"]);
            }
            
            // elimina le occorrenze in cui la form è presente, l'id componente delle form è 23
            eliminaOccorrenzeComponente($this->db,$this->id,23);
        }
        
        function eliminaMessaggio($idMessaggio) {
            $this->db->eseguiQueryCancellazione("geec_messaggiForm ",$idMessaggio);
        }
        
        function duplica($prefisso = "Copia di") {
            $this->db->eseguiQueryScrittura("CREATE TEMPORARY TABLE tabella_temporanea SELECT * FROM geec_form WHERE id=$this->id");
            $this->db->eseguiQueryScrittura("UPDATE tabella_temporanea SET id = 0;");
            $this->db->eseguiQueryScrittura("INSERT INTO geec_form SELECT * FROM tabella_temporanea;");
            $idNuovaForm = $this->db->idUltimoElemento();
            
            $this->db->eseguiQueryScrittura("UPDATE geec_form SET nome = CONCAT('$prefisso', ' ', nome) WHERE id=$idNuovaForm");
            
            $query       = "SELECT * FROM geec_elementiForm WHERE idForm='$this->id'";
            $risElementi = $this->db->eseguiQueryLettura($query);
            while($elementoDaCopiare = $risElementi->fetch_assoc()) {
                $query = "INSERT INTO `geec_elementiForm` (`id`, `idForm`, `posizione`, `nome`, `etichetta`, `valore`, `placeholder`, `tipo`, `opzioni`, `obbligatorio`) "
                    . "VALUES (NULL, '$idNuovaForm', '{$elementoDaCopiare["posizione"]}', '{$elementoDaCopiare["nome"]}', '{$elementoDaCopiare["etichetta"]}', '{$elementoDaCopiare["valore"]}', '{$elementoDaCopiare["placeholder"]}', '{$elementoDaCopiare["tipo"]}', '{$elementoDaCopiare["opzioni"]}', '{$elementoDaCopiare["obbligatorio"]}')";
                $this->db->eseguiQueryCreazione($query);
            }
            return $idNuovaForm;
        }
        
        function duplicaElemento($idElemento,$prefisso = "Copia di ") {
            $this->db->eseguiQueryScrittura("CREATE TEMPORARY TABLE tabella_temporanea SELECT * FROM geec_elementiForm WHERE id=$idElemento");
            $this->db->eseguiQueryScrittura("UPDATE tabella_temporanea SET id = 0;");
            $this->db->eseguiQueryScrittura("INSERT INTO geec_elementiForm SELECT * FROM tabella_temporanea;");
            $idElementoDuplicato = $this->db->idUltimoElemento();
            
            $this->db->eseguiQueryScrittura("UPDATE geec_elementiForm SET nome = CONCAT('$prefisso', ' ', nome) WHERE id=$idElementoDuplicato");
            return $idElementoDuplicato;
        }
        
        function caricaDatiDalDatabase() {
            $datiForm   = $this->db->leggiSingolaRiga("geec_form",$this->id);
            $this->nome = $datiForm["nome"];
            $this->tipoConfermaMessaggioInviato  = $datiForm["tipoConfermaMessaggioInviato"];
            $this->emailNotificaAmministratore   = $datiForm["emailNotificaAmministratore"];
            $this->rispondiA                     = $datiForm["rispondiA"];
            $this->oggettoNotificaAmministratore = $datiForm["oggettoNotificaAmministratore"];
            $this->testoMessaggioInviato         = $datiForm["testoMessaggioInviato"];
            $this->testoMessaggioErrore          = $datiForm["testoMessaggioErrore"];
            $this->paginaRingraziamento          = $datiForm["paginaRingraziamento"];
            $this->linkPrivacy                   = $datiForm["linkPrivacy"];
            $this->spazioOccupato                = $datiForm["spazioOccupato"];
            $this->formInLinea                   = $datiForm["formInLinea"];
            $this->spuntaPrivacy                 = $datiForm["spuntaPrivacy"];
            $this->azione                        = $datiForm["azione"];
            $this->etichettaPulsante             = $datiForm["etichettaPulsante"];
            $this->iconaPulsante                 = $datiForm["iconaPulsante"];
            $this->spazioOccupatoPulsante        = $datiForm["spazioOccupatoPulsante"];
            $this->stampaLinkPaginaForm          = $datiForm["stampaLinkPaginaForm"];
            $this->testo                         = $datiForm["testo"];
            $this->linkScriptEsterno             = $datiForm["linkScriptEsterno"];
            $this->usaAjax                       = $datiForm["usaAjax"];
            $this->linkScriptRicerca             = $datiForm["linkScriptRicerca"];
            $this->noteAggiuntive                = $datiForm["noteAggiuntive"];
            $this->attivaNotificaUtente          = $datiForm["attivaNotificaUtente"];
            $this->campoEmailNotificaUtente      = $datiForm["campoEmailNotificaUtente"];
            $this->nomeMittenteNotificaUtente    = $datiForm["nomeMittenteNotificaUtente"];
            $this->emailMittenteNotificaUtente   = $datiForm["emailMittenteNotificaUtente"];
            $this->oggettoNotificaUtente         = $datiForm["oggettoNotificaUtente"];
            $this->templateEmailNotificaUtente   = $datiForm["templateEmailNotificaUtente"];
            $this->mostraTitoloComponente        = $datiForm["mostraTitoloComponente"];
        }
        
        function creaElemento($tipo,$spazioOccupato) {
            $queryPosizione = "SELECT * FROM geec_elementiForm WHERE idForm=$this->id ORDER BY posizione DESC LIMIT 1";
            $risPosizione   = $this->db->eseguiQueryLettura($queryPosizione);
            $datiElemento   = $risPosizione->fetch_assoc();
            $posizione = ($risPosizione->num_rows>0) ? $datiElemento["posizione"] + 1 : 1;
            
            $query = "INSERT INTO `geec_elementiForm` (`id`, `idForm`, `posizione`, `spazioOccupato`, `nome`, `etichetta`, `valore`, `placeholder`, `tipo`, `opzioni`, `obbligatorio`) "
                    . "VALUES (NULL, '$this->id', '$posizione', '$spazioOccupato', '', '', '', '', '$tipo', '', '')";
            $idElemento = $this->db->eseguiQueryCreazione($query);
            return $idElemento;
        }
        
        function modificaElemento($id,$etichetta,$spazioOccupato,$nome,$valore,$placeholder,$tipo,$opzioni,$obbligatorio) {
            $query = "UPDATE geec_elementiForm SET etichetta='$etichetta', spazioOccupato='$spazioOccupato', nome='$nome', valore='$valore', placeholder='$placeholder', tipo='$tipo', opzioni='$opzioni', obbligatorio='$obbligatorio' WHERE id=$id";
            $this->db->eseguiQueryCreazione($query);
        }

        function modificaRapidaElemento($id,$etichetta,$nome,$valore) {
            $query = "UPDATE geec_elementiForm SET etichetta='$etichetta', nome='$nome', valore='$valore' WHERE id=$id";
            $this->db->eseguiQueryCreazione($query);
        }
        
        function spostaElemento($idElemento,$posizione) {
            $queryPosizione = "SELECT * FROM geec_elementiForm WHERE idForm=$this->id AND id != $idElemento ORDER BY posizione ASC";
            $risElementi    = $this->db->eseguiQueryLettura($queryPosizione);
            
            $posizioneCorrente = 1;
            while($elementoCorrente = $risElementi->fetch_assoc()) {
                if($posizione==$posizioneCorrente) {
                    $posizioneCorrente++;
                }
                $queryPosizione = "UPDATE geec_elementiForm SET posizione=$posizioneCorrente WHERE id = {$elementoCorrente["id"]} ";
                $this->db->eseguiQueryScrittura($queryPosizione);
                $posizioneCorrente ++;
            }
            $queryPosizioneElementoPrincipale = "UPDATE geec_elementiForm SET posizione=$posizione WHERE id = $idElemento ";
            $this->db->eseguiQueryScrittura($queryPosizioneElementoPrincipale);
        }
        
        function eliminaElemento($idElemento) {
            $this->db->eseguiQueryCancellazione("geec_elementiForm",$idElemento);
        }
        
        function stampaElementi($tipiCampo) {
            $query = "SELECT * FROM geec_elementiForm WHERE idForm=$this->id ORDER BY posizione ASC";
            $risultatoQuery = $this->db->eseguiQueryLettura($query);
            while($elementoForm = $risultatoQuery->fetch_assoc()) {
                $nomeEscape = filter_var($elementoForm["nome"],FILTER_SANITIZE_ADD_SLASHES);
                $campoObblicatorio = ($elementoForm["obbligatorio"]=="si") ? " *" : "";
            ?>
                    <div id="elementoComponente<?php echo $elementoForm["id"] ?>" class="card mb-3">
                        <div class="card-header py-1 pr-sm-1 d-sm-flex justify-content-between align-items-center text-center">
                            <div class="mb-1 mb-sm-0 d-flex align-items-center justify-content-start">
                                <small class="text-muted mr-3"><em><strong><?php echo $elementoForm["tipo"] ?></strong></em>  </small>
                            </div>
                            <div class="azioni d-flex align-items-center justify-content-end">
                                <div class="input-group input-group-sm d-flex align-items-center">
                                    <small class="text-muted mr-2">Pos.</small>
                                    <input type="number" class="form-control" aria-label="posizione" min="1" value="<?php echo $elementoForm["posizione"] ?>" id="posizioneElemento<?php echo $elementoForm["id"] ?>">
                                    <div class="input-group-append">
                                        <button class="btn btn-primary" type="button" onclick="spostaElementoInput(<?php echo $elementoForm["id"] ?>)">Salva</button>
                                    </div>
                                </div>
                                
                                <div class="btn-group" role="group" aria-label="Basic example">
                                    <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="Sposta su" onclick="spostaElemento(<?php echo $elementoForm["id"] ?>,<?php echo $elementoForm["posizione"]-1 ?>)"><i class="fas fa-arrow-up" ></i></button>
                                    <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="Sposta giu" onclick="spostaElemento(<?php echo $elementoForm["id"] ?>,<?php echo $elementoForm["posizione"]+1 ?>)"><i class="fas fa-arrow-down"></i></button>
                                    <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="Configura elemento" onclick="location.href='creaElemento.php?id=<?php echo $elementoForm["id"] ?>';"><i class="fas fa-edit"></i></button>
                                    <button type="button" class="btn btn-light elimina" data-toggle="tooltip" data-placement="bottom" title="Elimina" onclick="eliminaElemento(<?php echo $elementoForm["id"] ?>,'<?php echo $elementoForm["nome"] ?>','<?php echo $elementoForm["tipo"] ?>')" ><i class="far fa-trash-alt"></i></button>
                                </div>
                           </div>
                        </div>
                        <div class="card-body py-lg-0 d-flex align-items-center">
                            <img class="thumb d-none d-lg-block" src="../../../<?php echo $tipiCampo[$elementoForm["tipo"]] ?>">
                            <div class="form-row w-100">
                                <div class="form-group col-md-3 mb-2 mb-md-0">
                                    <label class="my-1">Nome</label>
                                    <input type="text" class="form-control" id="nomeElemento<?= $elementoForm["id"] ?>" placeholder="Nome" value="<?= $elementoForm["nome"] ?>" onchange="aggiornaValoreEtichetta(<?= $elementoForm["id"] ?>)">
                                </div>
                                <div class="form-group col-md-3 mb-2 mb-md-0">
                                    <label class="my-1">Etichetta</label>
                                    <input type="text" class="form-control" id="etichettaElemento<?= $elementoForm["id"] ?>" placeholder="Etichetta" value="<?= $elementoForm["etichetta"] ?>">
                                </div>
                                <div class="form-group col-md-4">
                                    <label class="my-1">Valore</label>
                                    <input type="text" class="form-control" id="valoreElemento<?= $elementoForm["id"] ?>" placeholder="Valore" value="<?= $elementoForm["valore"] ?>">
                                </div>
                                <div class="form-group col-md-3 col-xl-2">
                                    <label class="d-none d-md-block my-1">&nbsp;</label>
                                    <button type="button" class="btn btn-primary btn-block text-nowrap" onclick="modificaRapidaElemento(<?= $elementoForm["id"] ?>)"><i class="fas fa-check fa-fw mr-1"></i>Salva</button>
                                </div>
                            </div>
                        </div>
                    </div>
            <?php
            }
        }
        
        // getter & setter
        function getDb() {
            return $this->db;
        }

        function getId() {
            return $this->id;
        }

        function getNome() {
            return $this->nome;
        }

        public function getSpazioOccupato() {
            return $this->spazioOccupato;
        }
        
        function getEmailNotificaAmministratore() {
            return $this->emailNotificaAmministratore;
        }

        function getRispondiA() {
            return $this->rispondiA;
        }
        
        public function getOggettoNotificaAmministratore() {
            return $this->oggettoNotificaAmministratore;
        }
        
        function getLinkPrivacy() {
            return $this->linkPrivacy;
        }

        function getEtichettaPulsante() {
            return $this->etichettaPulsante;
        }
        
        public function getIconaPulsante() {
            return $this->iconaPulsante;
        }

        public function getSpazioOccupatoPulsante() {
            return $this->spazioOccupatoPulsante;
        }
        
        public function getTipoConfermaMessaggioInviato() {
            return $this->tipoConfermaMessaggioInviato;
        }
                
        function getTestoMessaggioInviato() {
            return $this->testoMessaggioInviato;
        }

        public function getTestoMessaggioErrore() {
            return $this->testoMessaggioErrore;
        }

        public function getFormInLinea() {
            return $this->formInLinea;
        }

        function getStile() {
            return $this->stile;
        }

        function getSpuntaPrivacy() {
            return $this->spuntaPrivacy;
        }

        public function getAzione() {
            return $this->azione;
        }

        function getTesto() {
            return $this->testo;
        }

        function getPaginaRingraziamento() {
            return $this->paginaRingraziamento;
        }

        public function getStampaLinkPaginaForm() {
            return $this->stampaLinkPaginaForm;
        }
                
        public function getLinkScriptEsterno() {
            return $this->linkScriptEsterno;
        }
        
        public function getLinkScriptRicerca() {
            return $this->linkScriptRicerca;
        }

        public function getUsaAjax() {
            return $this->usaAjax;
        }

        public function getNoteAggiuntive() {
            return $this->noteAggiuntive;
        }
        
        public function getAttivaNotificaUtente() {
            return $this->attivaNotificaUtente;
        }

        public function getCampoEmailNotificaUtente() {
            return $this->campoEmailNotificaUtente;
        }

        public function getNomeMittenteNotificaUtente() {
            return $this->nomeMittenteNotificaUtente;
        }

        public function getEmailMittenteNotificaUtente() {
            return $this->emailMittenteNotificaUtente;
        }

        public function getOggettoNotificaUtente() {
            return $this->oggettoNotificaUtente;
        }

        public function getMostraTitoloComponente() {
            return $this->mostraTitoloComponente;
        }

        public function getTemplateEmailNotificaUtente() {
            return $this->templateEmailNotificaUtente;
        }

        function setDb($db) {
            $this->db = $db;
        }

        function setId($id) {
            $this->id = $id;
        }

        function setNome($nome) {
            $this->nome = $nome;
        }

        function setEmailNotificaAmministratore($emailNotificaAmministratore) {
            $this->emailNotificaAmministratore = $emailNotificaAmministratore;
        }

        function setRispondiA($rispondiA) {
            $this->rispondiA = $rispondiA;
        }
        
        public function setOggettoNotificaAmministratore($oggettoNotificaAmministratore): void {
            $this->oggettoNotificaAmministratore = $oggettoNotificaAmministratore;
        }
        
        function setLinkPrivacy($linkPrivacy) {
            $this->linkPrivacy = $linkPrivacy;
        }

        function setEtichettaPulsante($etichettaPulsante) {
            $this->etichettaPulsante = $etichettaPulsante;
        }
        
        public function setFormInLinea($formInLinea): void {
            $this->formInLinea = $formInLinea;
        }

        public function setIconaPulsante($iconaPulsante): void {
            $this->iconaPulsante = $iconaPulsante;
        }

        public function setSpazioOccupatoPulsante($spazioOccupatoPulsante): void {
            $this->spazioOccupatoPulsante = $spazioOccupatoPulsante;
        }
       
        public function setTipoConfermaMessaggioInviato($tipoConfermaMessaggioInviato): void {
            $this->tipoConfermaMessaggioInviato = $tipoConfermaMessaggioInviato;
        }
        
        function setTestoMessaggioInviato($testoMessaggioInviato) {
            $this->testoMessaggioInviato = $testoMessaggioInviato;
        }

        public function setTestoMessaggioErrore($testoMessaggioErrore): void {
            $this->testoMessaggioErrore = $testoMessaggioErrore;
        }
        
        public function setSpazioOccupato($spazioOccupato) {
            $this->spazioOccupato = $spazioOccupato;
        }
        
        function setSpuntaPrivacy($spuntaPrivacy) {
            $this->spuntaPrivacy = $spuntaPrivacy;
        }

        public function setAzione($azione): void {
            $this->azione = $azione;
        }
        
        function setTesto($testo) {
            $this->testo = $testo;
        }

        function setPaginaRingraziamento($paginaRingraziamento) {
            $this->paginaRingraziamento = $paginaRingraziamento;
        }
        
        public function setStampaLinkPaginaForm($stampaLinkPaginaForm): void {
            $this->stampaLinkPaginaForm = $stampaLinkPaginaForm;
        }

        public function setLinkScriptEsterno($linkScriptEsterno): void {
            $this->linkScriptEsterno = $linkScriptEsterno;
        }
                
        public function setLinkScriptRicerca($linkScriptRicerca): void {
            $this->linkScriptRicerca = $linkScriptRicerca;
        }

        public function setUsaAjax($usaAjax): void {
            $this->usaAjax = $usaAjax;
        }
        
        public function setNoteAggiuntive($noteAggiuntive): void {
            $this->noteAggiuntive = $noteAggiuntive;
        }
        
        public function setAttivaNotificaUtente($attivaNotificaUtente): void {
            $this->attivaNotificaUtente = $attivaNotificaUtente;
        }

        public function setCampoEmailNotificaUtente($campoEmailNotificaUtente): void {
            $this->campoEmailNotificaUtente = $campoEmailNotificaUtente;
        }

        public function setNomeMittenteNotificaUtente($nomeMittenteNotificaUtente): void {
            $this->nomeMittenteNotificaUtente = $nomeMittenteNotificaUtente;
        }

        public function setEmailMittenteNotificaUtente($emailMittenteNotificaUtente): void {
            $this->emailMittenteNotificaUtente = $emailMittenteNotificaUtente;
        }

        public function setOggettoNotificaUtente($oggettoNotificaUtente): void {
            $this->oggettoNotificaUtente = $oggettoNotificaUtente;
        }
        
        public function setTemplateEmailNotificaUtente($templateEmailNotificaUtente): void {
            $this->templateEmailNotificaUtente = $templateEmailNotificaUtente;
        }

        public function setMostraTitoloComponente($mostraTitoloComponente): void {
            $this->mostraTitoloComponente = $mostraTitoloComponente;
        }
    }